//
//  SPLinearGradient-IBIntegration.m
//  SamplePlugIn
//
//  Created by Kai on 12.1.08.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

#import <InterfaceBuilderKit/InterfaceBuilderKit.h>
#import "SPLinearGradient.h"
#import "SPLinearGradient-IBIntegration.h"


//-------------------------------------------------------------------------------------------
@implementation SPLinearGradient (IBIntegration)
//-------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------
+ (NSSet*) keyPathsForValuesAffectingAppearance {
	// Create a combined key which can be observed to catch changes affecting the drawing
	// of the shadow.
	return [NSSet setWithObjects:@"startingColor", @"endingColor", @"angle", nil];
}

#pragma mark IBObjectIntegration ------------------------------------------------------------
//-------------------------------------------------------------------------------------------
- (void) ibPopulateKeyPaths:(NSMutableDictionary*)keyPaths {
	[super ibPopulateKeyPaths:keyPaths];
	
	// Remove the comments and replace "MyFirstProperty" and "MySecondProperty" 
	// in the following line with a list of your view's KVC-compliant properties.
	[[keyPaths objectForKey:IBAttributeKeyPaths] addObjectsFromArray:
					[NSArray arrayWithObjects:@"startingColor",
													  @"endingColor",
													  @"angle",
													  nil]];
}

//-------------------------------------------------------------------------------------------
- (void) ibPopulateAttributeInspectorClasses:(NSMutableArray*)classes {
	[super ibPopulateAttributeInspectorClasses:classes];
	[classes addObject:[SPLinearGradient_IBInspector class]];
}

//-------------------------------------------------------------------------------------------
// Although never used, the accessor for "appearance" must be present to make observation for
// it work.
- (id) appearance { return nil; }

//-------------------------------------------------------------------------------------------
@end


//-------------------------------------------------------------------------------------------
@implementation SPLinearGradient_IBInspector
//-------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------
/*
+ (NSSet*) keyPathsForValuesAffectingValueForKey:(NSString*)key {
	if ([key isEqualToString:@"hOffset"] || [key isEqualToString:@"vOffset"])
		return [NSSet setWithObject:@"inspectedObjectsController.selection.shadowOffset"];
	return [super keyPathsForValuesAffectingValueForKey:key];
}
*/
//-------------------------------------------------------------------------------------------
- (NSString*) viewNibName {
	return @"SPLinearGradientIBInspector";
}

//-------------------------------------------------------------------------------------------
- (NSString*) label {
	return @"Linear Gradient";
}


@end
